use rand::{Rng, RngCore, SeedableRng};

use std::sync::LazyLock;

const TRIALS: usize = 16;
pub const MAX_PRIME: u32 = 0xffff_ffff;
pub const LOG_PRIMES: usize = 16;
pub const NUM_PRIMES: usize = 1 << LOG_PRIMES;
pub static PRIMES: LazyLock<Vec<u32>> = LazyLock::new(|| {
    let mut rng = rand_chacha::ChaCha8Rng::seed_from_u64(0x1337cafe);
    let n = MAX_PRIME;
    let n = if n % 2 == 0 { n - 1 } else { n };
    (3..=n)
        .rev()
        .step_by(2)
        .filter(move |v| is_prime(&mut rng, *v))
        .take(NUM_PRIMES)
        .collect()
});

fn is_prime<R: RngCore>(rng: &mut R, p: u32) -> bool {
    fn modpow(b: u32, mut exp: u32, m: u32) -> u32 {
        let m = m as u64;
        let mut b = b as u64;
        let mut r = 1;
        while exp > 0 {
            if exp % 2 == 1 {
                r = r * b % m;
            }
            b = b * b % m;
            exp /= 2;
        }
        r as u32
    }
    (0..TRIALS).all(|_| modpow(rng.random_range(1..p), p - 1, p) == 1)
}
